TITLE    'Two Insulated Tubes'			         		{ exa141.pde }
SELECT     						{ Student Version }
   errlim=3e-4     ngrid=1     spectral_colors
VARIABLES   temp					{ SI units: m, K, W }
DEFINITIONS
   r0=0.1     d=0.15     r1=0.5     Lx=0.3     Ly=0.2
   k=0.03     heat=0             { Thermal conductivity and power density }
   fluxd_x=-k*dx(temp)     fluxd_y=-k*dy(temp)
   fluxd=vector( fluxd_x, fluxd_y)     fluxdm=magnitude( fluxd)
   f_angle=sign(fluxd_y)*arccos(fluxd_x/fluxdm)/pi*180
EQUATIONS
   div( fluxd)=heat
BOUNDARIES
region 'domain'
   start 'outer' (0,-r1) value(temp)=273		{ Frozen soil }
   arc( center=0,0)  angle=360
   start 'left' (-d-r0,0) value(temp)=323        { Exclude left hot water tube }
   arc( center=-d,0) angle=360
   start 'right' (d-r0,0) value(temp)=353        	{ Right hot water tube }
   arc( center=d,0) angle=360
PLOTS
   contour( temp)     surface( temp)
   vector( fluxd) norm      contour( f_angle)
   contour( fluxd_x)     contour( fluxd_y)     contour( fluxdm)		
   elevation( normal( fluxd)) on 'outer'
   elevation( -normal( fluxd)) on 'left'		{ Outwards from tube }
   elevation( -normal( fluxd)) on 'right'
END

